#!/bin/bash

if [[ $EUID -ne 0 ]]; then
   echo "This script must be run as root (use sudo)" 1>&2
   exit 1
fi

is_Raspberry=$(cat /proc/device-tree/model | awk  '{print $1}')
if [ "x${is_Raspberry}" != "xRaspberry" ] ; then
  echo "Sorry, this drivers only works on raspberry pi"
  exit 1
fi

echo "Starting WM8960 modules installation..."

apt update
apt-get -y install i2c-tools dkms

# install dtbos
echo "Installing device tree overlay..."
cp wm8960-soundcard.dtbo /boot/overlays

# set kernel modules
echo "Setting up kernel modules..."
grep -q "i2c-dev" /etc/modules || \
  echo "i2c-dev" >> /etc/modules  
grep -q "snd-soc-wm8960" /etc/modules || \
  echo "snd-soc-wm8960" >> /etc/modules  
grep -q "snd-soc-wm8960-soundcard" /etc/modules || \
  echo "snd-soc-wm8960-soundcard" >> /etc/modules  
  
# Detect config.txt location (can be in /boot or /boot/firmware)
CONFIG_PATH="/boot/config.txt"
if [ ! -f "$CONFIG_PATH" ]; then
  CONFIG_PATH="/boot/firmware/config.txt"
  if [ ! -f "$CONFIG_PATH" ]; then
    echo "Error: Could not find config.txt in /boot or /boot/firmware"
    exit 1
  fi
fi

echo "Using config file: $CONFIG_PATH"

# set dtoverlays
echo "Updating configuration in $CONFIG_PATH..."
sed -i -e 's:#dtparam=i2c_arm=on:dtparam=i2c_arm=on:g' $CONFIG_PATH || true
sed -i -e 's:#dtparam=i2s=on:dtparam=i2s=on:g' $CONFIG_PATH || true

grep -q "dtoverlay=i2s-mmap" $CONFIG_PATH || \
  echo "dtoverlay=i2s-mmap" >> $CONFIG_PATH

grep -q "dtparam=i2s=on" $CONFIG_PATH || \
  echo "dtparam=i2s=on" >> $CONFIG_PATH

grep -q "dtoverlay=wm8960-soundcard" $CONFIG_PATH || \
  echo "dtoverlay=wm8960-soundcard" >> $CONFIG_PATH
  
# install config files
echo "Installing configuration files..."
mkdir -p /etc/wm8960-soundcard
cp *.conf /etc/wm8960-soundcard
cp *.state /etc/wm8960-soundcard

# set service 
echo "Setting up service..."
cp wm8960-soundcard /usr/bin/
# Fix permission issue
chmod +x /usr/bin/wm8960-soundcard
cp wm8960-soundcard.service /lib/systemd/system/
systemctl daemon-reload
systemctl enable wm8960-soundcard.service 
systemctl start wm8960-soundcard
# Don't start the service yet, wait until after reboot

echo "------------------------------------------------------"
echo "Installation completed!"
echo "Please reboot your raspberry pi to apply all settings"
echo "Enjoy!"
echo "------------------------------------------------------"
